unit Res1;

interface
uses MainData;

//   
type TPntXY = record
   dX : integer;      //    X -  
   dY : integer;      //    Y -  
end;

//        
type TPntRes = record
   dX    : smallint;  // X -    
   dY    : smallint;  // Y -    
   PRes  : integer;   //   
   NRes  : byte;
end;

//        
type TSec = record
   RVec : byte;
   APnt : TPntRes;
end;

//       
const
   BegA : TPntXY = (dX : -1; dY : -1);  //    ( Left, Top   )
   EndA : TPntXY = (dX :  1; dY :  1);  //     ( Right, Down )

//      
const RArea : array[0..7] of TSec =
(
  //  0. : 
  ( RVec :  0;
    APnt : (dX :  0; dY : -1; PRes : 1; NRes : 0)),
  //  1. :   
  ( RVec :  1;                      // COS(45) = 0.7071
    APnt : (dX :  1; dY : -1; PRes : 1; NRes : 0)),
  //  2. : 
  ( RVec :  2;
    APnt : (dX :  1; dY :  0; PRes : 1; NRes : 0)),
   //  3. :   
  ( RVec :  3;
    APnt : (dX :  1; dY :  1; PRes : 1; NRes : 0)),
   //  4. : 
  ( RVec :  4;
    APnt : (dX :  0; dY :  1; PRes : 1; NRes : 0)),
   //  5. :   
  ( RVec :  5;
    APnt : (dX : -1; dY :  1; PRes : 1; NRes : 0)),
   //  6. : 
  ( RVec :  6;
    APnt : (dX : -1; dY :  0; PRes : 1; NRes : 0)),
   //  7. :   
  ( RVec : 7;
    APnt : (dX : -1; dY : -1; PRes : 1; NRes : 0))
); // end of const LArea


//    [Row, Col]    
PROCEDURE CalcRArea (var RqArr : TArrBioCell; Row, Col : integer);

implementation


//        
function TestAreaIndx (RqArr : TArrBioCell; Row, Col : integer) : boolean;
begin
   Result := False;
   if ((Row + BegA.dY) >=  Low(RqArr)) and
      ((Row + EndA.dY) <= High(RqArr))
  then
     if ((Col + BegA.dX) >=  Low(RqArr[Row])) and
        ((Col + EndA.dX) <= High(RqArr[Row]))
     then Result := True;
end;

//        
function TestPntIndx (RqArr : TArrBioCell; Row, Col, Sec : integer) : boolean;
begin
   Result := False;
   with RArea[Sec].APnt
   do begin
     if ((Row + dY) >= Low(RqArr)) and
        ((Row + dY) <= High(RqArr))
     then
        if ((Col + dX) >= Low(RqArr[Row])) and
           ((Col + dX) <= High(RqArr[Row]))
        then Result := True;
   end;
end;


//    [Row, Col]    
PROCEDURE CalcRArea (var RqArr : TArrBioCell; Row, Col : integer);
type TSC = record
   Sec  : smallint;    //     
   Cnt  : smallint;    //    
   Res  : integer;     //   
end;
type TSecRes = record
   PRes  : integer;    //      
   Stat  : byte;       //   
   S0    : TSC;        //     
   S7    : TSC;        //     
   SM    : TSC;        //     
   SW    : TSC;        //    
end;

//   
var ArRes  : TSecRes;
    Sec    : integer;

//     [Row, Col]    
procedure CalcRPnt(CelEn : boolean);
begin

   ArRes.Stat := ArRes.Stat or $01;  //   ,  
   if CelEn
   then begin
      with RArea[Sec]
      do begin
        if RqArr[Row + APnt.dY, Col + APnt.dX].CStat = 0
        then begin
           ArRes.Stat := ArRes.Stat and (not $01);  //  
           //    
           ArRes.PRes := ArRes.PRes + APnt.PRes;
           //    
           ArRes.SW.Sec := Sec;
           Inc(ArRes.SW.Cnt);
           ArRes.SW.Res := ArRes.SW.Res + APnt.PRes;
           //     
           case Sec of
           0 : ArRes.Stat := ArRes.Stat or $10;    //   
           7 : ArRes.Stat := ArRes.Stat or $41;    //   
           end;
        end;
      end;
   end;

   with ArRes
   do begin
      // ,   
      if (Stat and $01) > 0
      then begin
          // ,     
          if (SW.Res > 0) and (SW.Res >= SM.Res)
          then begin
              //    
              if SW.Res >= SM.Res
              then begin
                 //       
                 SM:= SW;
              end
              else begin
                 //       
                 if Random(2) > 0 then SM:= SW;
              end;
          end;
          if ((Stat and $10) > 0) and (SW.Sec < 7)
          then begin
              //   
              S0 := SW;
              Stat := Stat or $20;
              Stat := Stat and (not $10);
          end;
          //   
          if SW.Sec = 7 then S7 := SW;
          //     
          FillChar(SW, SizeOF(TSC), #0);
      end;
   end;
end;

BEGIN
   //    Area
   FillChar(ArRes, SizeOF(ArRes), #0);
   if TestAreaIndx (RqArr, Row, Col)
   then begin
      //        RqArr
      for Sec := 0 to 7 do CalcRPnt(True);
   end
   else begin
      //        RqArr
      for Sec := 0 to 7
      do begin
         //       
         if TestPntIndx (RqArr, Row, Col, Sec)
         then CalcRPnt(True)
         else CalcRPnt(False);
      end;
   end;
   //    [Row, Col]
   RqArr[Row, Col].PRes := RqArr[Row, Col].PRes + ArRes.PRes;
   if RqArr[Row, Col].PRes > 999
   then RqArr[Row, Col].PRes := 999;

   // ,       
   if ArRes.SM.Res > 0
   then begin
      if (ArRes.Stat and $60) = $60
      then begin
         //     
         ArRes.S0.Sec := 7 + ArRes.S0.Cnt;
         ArRes.S0.Cnt := ArRes.S0.Cnt + ArRes.S7.Cnt;
         ArRes.S0.Res := ArRes.S0.Res + ArRes.S7.Res;
         if ArRes.S0.Res > ArRes.SM.Res
         then begin
            //     
            ArRes.SM := ArRes.S0;
         end;
      end;
      if ArRes.SM.Res < 8
      then begin
         //    ( )    
         ArRes.SM.Sec := ArRes.SM.Sec - (ArRes.SM.Cnt div 2);
         if ArRes.SM.Sec > 7 then ArRes.SM.Sec := ArRes.SM.Sec - 8;
      end
      else ArRes.SM.Sec := random(7);
      //       
      RqArr[Row, Col].MVec := ArRes.SM.Sec;
      RqArr[Row, Col].dMX  := RArea[ArRes.SM.Sec].APnt.dX;
      RqArr[Row, Col].dMY  := RArea[ArRes.SM.Sec].APnt.dY;
      RqArr[Row, Col].SRes := ArRes.SM.Res;
      if RqArr[Row, Col].SRes > 64
      then RqArr[Row, Col].SRes := 64;
   end
   else begin
      RqArr[Row, Col].MVec := 0;
      RqArr[Row, Col].dMX  := 0;
      RqArr[Row, Col].dMY  := 0;
      RqArr[Row, Col].SRes := 0;
   end;
END;

end.
